/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.display;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class PHPInspectExpression
extends PlatformObject
implements IErrorReportingExpression,
IDebugEventSetListener {
    private IValue fValue;
    private String fExpression;
    private IWatchExpressionResult fResult;

    public PHPInspectExpression(String expression, IValue value) {
        this.fValue = value;
        this.fExpression = expression;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public PHPInspectExpression(IWatchExpressionResult result) {
        this(result.getExpressionText(), result.getValue());
        this.fResult = result;
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IDebugTarget getDebugTarget() {
        IValue value = this.getValue();
        if (value != null) {
            return this.getValue().getDebugTarget();
        }
        if (this.fResult != null) {
            return this.fResult.getValue().getDebugTarget();
        }
        return null;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 8: {
                    if (!event.getSource().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
                    break;
                }
                case 2: {
                    IDebugElement source;
                    if (event.getDetail() == 128 || !(event.getSource() instanceof IDebugElement) || !(source = (IDebugElement)event.getSource()).getDebugTarget().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    public String[] getErrorMessages() {
        return PHPInspectExpression.getErrorMessages(this.fResult);
    }

    public static String[] getErrorMessages(IWatchExpressionResult result) {
        if (result == null) {
            return new String[0];
        }
        String[] messages = result.getErrorMessages();
        if (messages.length > 0) {
            return messages;
        }
        DebugException exception = result.getException();
        if (exception != null) {
            return new String[]{exception.getMessage()};
        }
        return new String[0];
    }
}

